(*| 21:50 15/07/1992 *)
UNIT GXCommon;

INTERFACE

CONST
  MiscBufferSize = $FFC0;
  Screen_Width = 320;
  Screen_Height = 200;

TYPE
  TFileFormat = (DAC,PCX,GIF,EXE,VGAP,BMP,RAW);
  TDacBuffer = ARRAY[0..$2FF] OF BYTE;
  TVideoBuffer = ARRAY[0..$7FFF] OF BYTE;
  TMiscBuffer = ARRAY[0..MiscBufferSize] OF BYTE;
  TFileName = STRING[50];
  PMiscBuffer = ^TMiscBuffer;
  PVideoBuffer = ^TVideoBuffer;

VAR
  VBuf1,VBuf2: PVideoBuffer;
  DacBuffer: TDacBuffer;
  MiscBuffer1,MiscBuffer2: PMiscBuffer;
  FileName: TFileName;
  FileFormat: TFileFormat;

FUNCTION IndexPtr(OldPtr:Pointer; Index: Integer):Pointer;

PROCEDURE ShowFormat;

IMPLEMENTATION

FUNCTION IndexPtr(OldPtr:Pointer; Index: Integer):Pointer;
BEGIN
  IndexPtr:=Ptr(Seg(OldPtr^),Ofs(OldPtr^)+Index);
END;  { IndexPtr }

PROCEDURE ShowFormat;
BEGIN
  CASE FileFormat OF
    DAC  :  Write('Binary');
    PCX  :  Write('PCX');
    GIF  :  Write('GIF');
    EXE  :  Write('EXE');
    VGAP :  Write('VGAPaint');
    BMP  :  Write('BMP');
    RAW  :  Write('RAW');
  END;
END;  { ShowFormat }

BEGIN
  FileName := '';
  FileFormat := DAC;
  NEW(VBuf1);
  NEW(VBuf2);
  NEW(MiscBuffer1);
  NEW(MiscBuffer2);
END.
